/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.ELFAnalyser;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.Union$CallbackResultContext;
import com.sun.jna.Union$PointerType;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Platform {
    public static final int UNSPECIFIED = -1;
    public static final boolean HAS_DLL_CALLBACKS;
    public static final int LINUX = 1;
    public static final int KFREEBSD = 10;
    public static final int WINDOWSCE = 6;
    public static final String MATH_LIBRARY_NAME;
    public static final int SOLARIS = 3;
    public static final int GNU = 9;
    public static final int OPENBSD = 5;
    public static final int FREEBSD = 4;
    public static final boolean HAS_AWT;
    public static final int WINDOWS = 2;
    public static final int MAC = 0;
    public static final boolean HAS_JAWT;
    public static final String C_LIBRARY_NAME;
    public static final String ARCH;
    private static final int osType;
    public static final boolean HAS_BUFFERS;
    public static final int NETBSD = 11;
    public static final String RESOURCE_PREFIX;
    public static final int ANDROID = 8;
    public static final int AIX = 7;
    public static final boolean RO_FIELDS;

    static {
        String osName = System.getProperty(LastErrorException.l(Union$PointerType.H("\ua011\ufb03\uee55\ueeb5\ud1e2\ua1a0\u48c9")));
        if (osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua032\ufb19\uee15\ueeae\ud1fb")))) {
            if (LastErrorException.l(Union$PointerType.H("\ua063\ufb68\uee6e\ueed4\ud193\ua1df")).equals(System.getProperty(LastErrorException.l(Union$PointerType.H("\ua06d\ufb68\uee74\ueec3\ud1d4\ua1c2\u48b8\u47d1E\u5794\uaa70\uda85"))).toLowerCase())) {
                osType = 8;
                System.setProperty(LastErrorException.l(Union$PointerType.H("\ua06d\ufb67\uee63\uee8c\ud194\ua1db\u48a0\u4791[\u5794\uaa7e\uda8b")), LastErrorException.l(Union$PointerType.H("\ua073\ufb7b\uee77\ueec7")));
            } else {
                osType = 1;
            }
        } else {
            osType = osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua03f\ufb39\uee23"))) ? 7 : (osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua033\ufb11\uee18"))) || osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua043\ufb68\uee70\ueed5\ud193\ua1da"))) ? 0 : (osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua050\ufb60\uee6c\ueec6\ud195\ua1c3\u48a6\u47dfh\u57b0"))) ? 6 : (osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua029\ufb19\uee15\ueebf\ud1ec\ua1ba\u48df"))) ? 2 : (osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua02d\ufb1f\uee17\ueeba\ud1f1\ua1a4\u48df"))) || osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua02d\ufb05\uee15\uee94\ud1d0"))) ? 3 : (osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua038\ufb02\uee1e\ueebe\ud1c1\ua19e\u48e8"))) ? 4 : (osName.startsWith(LastErrorException.l(Union$PointerType.H("\ua031\ufb00\uee1e\ueeb5\ud1c1\ua19e\u48e8"))) ? 5 : (osName.equalsIgnoreCase(LastErrorException.l(Union$PointerType.H("\ua019\ufb1e\uee0e"))) ? 9 : (osName.equalsIgnoreCase(LastErrorException.l(Union$PointerType.H("\ua060\ufb67\uee77\uee8d\ud191\ua1d2\u48a7\u479aN\u5797\uaa6e\uda84"))) ? 10 : (osName.equalsIgnoreCase(LastErrorException.l(Union$PointerType.H("\ua069\ufb6c\uee76\ueec0\ud189\ua1d0"))) ? 11 : -1)))))))));
        }
        boolean hasBuffers = false;
        try {
            Class.forName(LastErrorException.l(Union$PointerType.H("\ua014\ufb11\uee0d\ueeba\ud1ad\ua1a3\u48c5\u47e9|\u57ce\uaa11\udaff\u2dae\ud90b\u70ac")));
            hasBuffers = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAS_AWT = osType != 6 && osType != 8 && osType != 7;
        HAS_JAWT = HAS_AWT && osType != 0;
        HAS_BUFFERS = hasBuffers;
        boolean bl = RO_FIELDS = osType != 6;
        String string = osType == 2 ? LastErrorException.l(Union$PointerType.H("\ua06a\ufb7a\uee74\ueec1\ud188\ua1c0")) : (C_LIBRARY_NAME = osType == 6 ? LastErrorException.l(Union$PointerType.H("\ua01d\ufb1f\uee09\ueebe\ud1e7\ua1a1\u48c0")) : Union$PointerType.H("\ua076"));
        MATH_LIBRARY_NAME = osType == 2 ? LastErrorException.l(Union$PointerType.H("\ua06a\ufb7a\uee74\ueec1\ud188\ua1c0")) : (osType == 6 ? LastErrorException.l(Union$PointerType.H("\ua01d\ufb1f\uee09\ueebe\ud1e7\ua1a1\u48c0")) : Union$PointerType.H("\ua078"));
        ARCH = Platform.getCanonicalArchitecture(System.getProperty(LastErrorException.l(Union$PointerType.H("\ua011\ufb03\uee55\ueeba\ud1f1\ua1ae\u48c4"))), osType);
        HAS_DLL_CALLBACKS = osType == 2 && !ARCH.startsWith(LastErrorException.l(Union$PointerType.H("\ua01f\ufb11\uee09\ueeb8\ud1eb")));
        RESOURCE_PREFIX = Platform.getNativeLibraryResourcePrefix();
    }

    public static final boolean isWindows() {
        return osType == 2 || osType == 6;
    }

    public static final int getOSType() {
        return osType;
    }

    static String getNativeLibraryResourcePrefix() {
        String prefix = System.getProperty(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u5083\u54fb\u355a\uf232\u6c82\u1afb\ua37f\u5cc0\u3388\u0bed")));
        if (prefix != null) {
            return prefix;
        }
        return Platform.getNativeLibraryResourcePrefix(Platform.getOSType(), System.getProperty(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50ff\u549f\u356c\uf204\u6cf9\u1a93\ua30b"))), System.getProperty(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50ff\u549f\u356c\uf20b\u6cea\u1a9d\ua306"))));
    }

    public static final boolean isFreeBSD() {
        return osType == 4;
    }

    public static final boolean isMac() {
        return osType == 0;
    }

    public static final boolean isGNU() {
        return osType == 9;
    }

    private /* synthetic */ Platform() {
    }

    static String getCanonicalArchitecture(String arch, int platform) {
        arch = arch.toLowerCase().trim();
        if (LastErrorException.l(Union$CallbackResultContext.U("\uad27\uf134\u18e0\u8f0a\u88a1\u6d17\ub05d")).equals(arch)) {
            arch = LastErrorException.l(Union$CallbackResultContext.U("\uad27\uf12b\u18f4"));
        } else if (LastErrorException.l(Union$CallbackResultContext.U("\uad27\uf134\u18e0\u8f0a\u88a1\u6d17\ub05d\uc0a2\u1c83")).equals(arch)) {
            arch = LastErrorException.l(Union$CallbackResultContext.U("\uad27\uf12b\u18f4\u8f59\u88e7"));
        } else if (LastErrorException.l(Union$CallbackResultContext.U("\uad47\uf111\u18d6\u8f20")).equals(arch) || LastErrorException.l(Union$CallbackResultContext.U("\uad47\uf114\u18d6\u8f20")).equals(arch)) {
            arch = LastErrorException.l(Union$CallbackResultContext.U("\uad2f\uf163\u18a1"));
        } else if (LastErrorException.l(Union$CallbackResultContext.U("\uad56\uf11a\u18d8\u8f49\u889c\u6d2a")).equals(arch) || LastErrorException.l(Union$CallbackResultContext.U("\uad36\uf136\u18f3\u8f59\u88e7")).equals(arch)) {
            arch = LastErrorException.l(Union$CallbackResultContext.U("\uad56\uf11a\u18d8\u8f3b\u889c\u6d2a"));
        } else if (LastErrorException.l(Union$CallbackResultContext.U("\uad54\uf143\u189c\u8f75\u88c2\u6d41\ub071\uc0d9")).equals(arch)) {
            arch = LastErrorException.l(Union$CallbackResultContext.U("\uad24\uf168\u18ae\u8f5f\u88ab"));
        }
        if (LastErrorException.l(Union$CallbackResultContext.U("\uad27\uf12b\u18f4\u8f59\u88e7")).equals(arch) && LastErrorException.l(Union$CallbackResultContext.U("\uad42\uf14b\u189a\u8f62\u88c6\u6d7b")).equals(System.getProperty(LastErrorException.l(Union$CallbackResultContext.U("\uad5d\uf157\u1880\u8f38\u88c9\u6d6e\ub032\uc0c3\u1cab\u413e\ue5d2\u5626\uea20\uf781"))))) {
            arch = LastErrorException.l(Union$CallbackResultContext.U("\uad27\uf12b\u18f4\u8f59\u88e7\u6d0b\ub05b"));
        }
        if (LastErrorException.l(Union$CallbackResultContext.U("\uad36\uf129\u18fa")).equals(arch) && platform == 1 && Platform.isSoftFloat()) {
            arch = LastErrorException.l(Union$CallbackResultContext.U("\uad36\uf129\u18fa\u8f0a\u88bf"));
        }
        return arch;
    }

    public static final boolean isSPARC() {
        return ARCH.startsWith(LastErrorException.l(Klass$JNIEnv.n("\ud8f8\u0b37\u72ab\ufc4c\u5943")));
    }

    static String getNativeLibraryResourcePrefix(int osType, String arch, String name) {
        String osPrefix;
        arch = Platform.getCanonicalArchitecture(arch, osType);
        switch (osType) {
            case 8: {
                if (arch.startsWith(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50f1\u549e\u352f")))) {
                    arch = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50f1\u549e\u352f"));
                }
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u5088\u54fb\u355f\uf26e\u6c9d\u1ae0\ua37e\u5c8b")) + arch;
                break;
            }
            case 2: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u509e\u54fc\u3555\uf22f\u6cc0\u1aa4")) + arch;
                break;
            }
            case 6: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u509e\u54a6\u3509\uf27f\u6c97\u1aa4")) + arch;
                break;
            }
            case 0: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50f4\u548d\u3530\uf212\u6ce2\u1a9e\ua34e")) + arch;
                break;
            }
            case 1: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u5085\u54fc\u3555\uf269\u6c8a\u1aa4")) + arch;
                break;
            }
            case 3: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u509a\u54e0\u3555\uf273\u6c81\u1aa4")) + arch;
                break;
            }
            case 4: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u508f\u54e7\u355e\uf279\u6c90\u1afa\ua37e\u5c8b")) + arch;
                break;
            }
            case 5: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u5086\u54e5\u355e\uf272\u6c90\u1afa\ua37e\u5c8b")) + arch;
                break;
            }
            case 11: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50fe\u5489\u3536\uf207\u6cf8\u1a94\ua34e")) + arch;
                break;
            }
            case 10: {
                osPrefix = LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50fb\u548a\u3530\uf200\u6cee\u1a92\ua310\u5cbb\u33b5")) + arch;
                break;
            }
            default: {
                osPrefix = name.toLowerCase();
                int space = osPrefix.indexOf(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50b0")));
                if (space != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = osPrefix + LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u50bd")) + arch;
            }
        }
        return osPrefix;
    }

    public static final boolean hasRuntimeExec() {
        return !Platform.isWindowsCE() || !LastErrorException.l(Union$CallbackResultContext.U("\u1a0b\u0f18")).equals(System.getProperty(LastErrorException.l(Union$CallbackResultContext.U("\u1a2b\u0f40\uda35\u9ce2\u4456\u106b\ud022\u0354\u63e9\ua437\u2cb9\u7320"))));
    }

    public static final boolean isIntel() {
        return ARCH.startsWith(LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u55da\u38a7\u023e")));
    }

    public static final boolean is64Bit() {
        String model = System.getProperty(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub78a\u07a5\u8b55\u87e7\ud39c\ufb18\u5940\uaa94\u5dbb\u5639\u87c5\udd57\u30cb\u820b\u344c\u1d1c\ub123\uc1d5\ua005")), System.getProperty(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub7e3\u07c6\u8b2f\u879e\ud3ed\ufb71\u5937\uaaab\u5d9a\u5649\u87f3\udd38\u30ba\u8228\u3435\u1d65\ub15a\uc1ac"))));
        if (model != null) {
            return LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub7b6\u079d")).equals(model);
        }
        if (LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub7f8\u0791\u8b74\u879d\ud3b2\ufb27")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub7e9\u07c8\u8b74\u8784")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub789\u07a0\u8b58\u87ff\ud3c9")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub789\u07a0\u8b58\u87ff\ud3c9\ufb06\u5946")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub78a\u07a0\u8b5a\u87bb\ud39e\ufb1c\u591a")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub7ed\u07c0\u8b32\u87c3\ud3b2\ufb27")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub7ed\u07c0\u8b32\u87c3\ud3b2\ufb27\u593f\uaae9")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub795\u07bf\u8b54\u87a7\ud39a\ufb0b\u5951\uaa9f\u5dfd\u566b\u8790")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub798\u07bd\u8b5f\u87ff\ud3c9")).equals(ARCH) || LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub798\u07b1\u8b49\u87aa\ud395\ufb5c\u5917")).equals(ARCH)) {
            return true;
        }
        return Native.POINTER_SIZE == 8;
    }

    public static final boolean isWindowsCE() {
        return osType == 6;
    }

    public static final boolean isMIPS() {
        block3: {
            block2: {
                if (ARCH.equals(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub3fc\u56c4\u65de\ube7c")))) break block2;
                if (!ARCH.equals(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub3fc\u56c4\u65de\ube7c\u4757\u4558"))) && !ARCH.equals(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub3fc\u56c4\u65de\ube7c\u4704\u4500"))) && !ARCH.equals(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\ub3fc\u56c4\u65de\ube7c\u4757\u4558\u608b\u496f")))) break block3;
            }
            return true;
        }
        return false;
    }

    public static final boolean isSolaris() {
        return osType == 3;
    }

    public static final boolean isNetBSD() {
        return osType == 11;
    }

    public static final boolean isAndroid() {
        return osType == 8;
    }

    public static final boolean isARM() {
        return ARCH.startsWith(LastErrorException.l(Klass$JNIEnv.n("\u6ebc\u7629\u0d18"))) || ARCH.startsWith(LastErrorException.l(Klass$JNIEnv.n("\u6ebc\u763a\u0d07\u3aea\uaae3")));
    }

    public static final boolean isOpenBSD() {
        return osType == 5;
    }

    static boolean isSoftFloat() {
        try {
            File self = new File(LastErrorException.l(Klass$JNIEnv.n("\u04ee\u9a66\ueb63\u0e8b\ue08a\uab57\u24a5\uefd3\ua7c1\u986d\u28f9\ua9cb\u0b7d\u9d2e")));
            if (self.exists()) {
                ELFAnalyser ahfd = ELFAnalyser.analyse(self.getCanonicalPath());
                return !ahfd.isArmHardFloat();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Platform.class.getName()).log(Level.INFO, LastErrorException.l(Klass$JNIEnv.n("\u04fe\u9a0e\ueb01\u0ef1\ue0f5\uab65\u248f\uefbb\ua7bb\u9852\u28dd\ua9b2\u0b1d\u9d56\udac1\u4abb\uf5a5\uea19\u65b0\u570b\u6709\uaedc\ue724\uac52\ua488\udc1d\u2d44\ue816\ufcd8\ue2d0\ub713\uf683\ua3a6\u8f8a\u6b60\uc299\u9af4\ud55e\ud2be\u7dbe\u917c\u1da7\uac9b\u17cf\u21c1\u3c50\uf218\u6f5c\u4c37\u5d1e\udf28\u00d6\u0fc1")), ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Platform.class.getName()).log(Level.INFO, LastErrorException.l(Klass$JNIEnv.n("\u0492\u9a73\ueb72\u0e91\ue09b\uab11\u24a2\uefcf\ua7e8\u9873\u28b5\ua9cb\u0b75\u9d3f\udaf1\u4a8a\uf59d\uea30\u65cc\u5775\u677a\uaee6\ue74b\uac6e\ua4fc\udc6c\u2d73\ue866\ufca0\ue2bf\ub724\uf6b4\ua3d7\u8fa1\u6b1e\uc2bb\u9a95\ud530\ud288\u7dd0\u914b\u1ddf\uace0\u17bf\u21aa\u3c26\uf266\u6f34\u4c45\u5d21\udf03\u00b9\u0fe4\u2916\ub953\udcbe\uf4d2\u9a9f\u263c\ucc07\u1da1\u38b5\uf7a0\u1b6c\u7c6c\ud9c9\uda3c\u1f23\u2331\u8cba\uf3b3\uf92e")), ex);
        }
        return false;
    }

    public static final boolean isX11() {
        return !Platform.isWindows() && !Platform.isMac();
    }

    public static final boolean isLinux() {
        return osType == 1;
    }

    public static final boolean isPPC() {
        return ARCH.startsWith(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u6c8e\ub3ea\u68ab")));
    }

    public static final boolean isAIX() {
        return osType == 7;
    }

    public static final boolean iskFreeBSD() {
        return osType == 10;
    }

    public static final boolean isLoongArch() {
        return ARCH.startsWith(LastErrorException.l(Union$CallbackResultContext.U("\u2a40\udbd1\u2e50\u24ba\u90a9\u3ffb\u5046\ub792\u761f")));
    }
}

